@extends('Backend.layouts.app')
@section('content')
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Testimonial Page</h3>
    <a href="{{route('testimonials.create')}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Tetimonial</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
        <div class="table-responsive p-1">
          <table id="download-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr>
                <th>Photo</th>
                <th>Name</th>
                <th>Identification</th>
                <th>Message</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td><img class="img-thumbnail" src="{{asset('testimonial/'.$l->profile_image)}}" width="50" height="50" /></td>
                <td class="wordwrap">{{$l->name}}</td>
                <td class="wordwrap">{{$l->post}}</td>
                <td class="col-md-5">{!! $l->message !!}</td>
                <td class="col-md-2 col-sm-4">
                    <a class="btn btn-info btn-sm" href="{{route('testimonials.edit',$l->id)}}">Edit</a>
                    <a class="btn btn-danger btn-sm" href="{{route('testimonials.delete',$l->id)}}">
                      <i class="fa fa-trash"></i>
                    </a>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table --> 
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#download-table').DataTable({
      "columnDefs": [{
          "width": "50px",
          "targets": 0
        },
        {
          "width": "90px",
          "targets": 1
        },
        {
          "width": "100px",
          "targets": 2
        },
        {
          "width": "auto",
          "targets": 3
        },
        {
          "width": "60px",
          "targets": 4
        },
      ],
    });
  });
</script>
@endsection