@extends('Backend.layouts.app')
@section('content')
<style type="text/css">
	label{
		font-weight: bold !important;
	}
	span.required{
		color:red;
	}

	.btn-file{
		border: 1px solid #000;
		height: 50px;
		font-size: 20px;
	}
	.btn-file input[type=file] {
	  position: absolute;
	  top: 0;
	  right: 0;
	  min-width: 100%;
	  min-height: 100%;
	  font-size: 100px;
	  text-align: right;
	  filter: alpha(opacity=0);
	  opacity: 0;
	  outline: none;
	  background: white;
	  cursor: inherit;
	  display: block;
	}
	span.file{
		font-size: 15px;
		font-weight: 400;
		padding: 5px;
		color:#4D525B;
	}
	.uploadfrm{
		border:1px dotted #BEC0C2;
		padding: 10px;
		margin:10px;
	}
</style>
	<!-- Page Header -->
	<div class="page-header row no-gutters py-4">
	  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
	    <span class="text-uppercase page-subtitle">Testimonials Page</span>
	    <h3 class="page-title">Add New Testimonial </h3>
	  </div>
	</div>
	<!-- End Page Header -->
	<form class="add-new-post" action="{{isset($edit)?route('testimonials.update', $edit->id):route('testimonials.store')}}" method="post" enctype="multipart/form-data">
	<div class="row">
		<div class="col-lg-9 col-md-12">
			<!-- Add New Post Form -->
			<div class="card card-small mb-3">
				<div class="card-body">
						@csrf
						@if(isset($edit))
						<input type="hidden" name="id" value="{{$edit->id}}" />
						@endif	
						<input type="hidden" name="profile_image" value="{{ isset($edit)?$edit->profile_image:'empty' }}" />
						<div class="row col-md-12 mb-5">
							<div class="col-md-4">
								<label>Profile Image<span class="required">*</span></label>
							</div>
							<div class="col-md-7 card p-3">
							<img class="{{isset($edit)?'d-block':'d-none'}} m-auto" id="logo" src="{{isset($edit)?asset('testimonial/'.$edit->profile_image):''}}" width="150px" height="150px"/>
								<input class="form-control mt-2" type="file" id="mediaFile" name="image"/>
								@if($errors->first('image'))
								<div class="text text-danger">
									* {{$errors->first('image')}}
								</div>
								@endif
							</div>
						</div>			
						<div class="row pl-3 pr-3">
							<div class="col-md-6 col-sm-6 p-0 pl-3">
								<label for="name" class="">Name <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-1 {{ $errors->first('name') ? 'is-invalid':'' }}" id="name" type="text" name="name" value="{{old('name')?old('name'):(isset($edit)?$edit->name:'')}}" placeholder="Enter name here">
								@if($errors->first('name'))
									<div class="text text-danger ">
										** {{$errors->first('name')}}
									</div>
								@endif
							</div>
							<div class="col-md-6 col-sm-6 p-0 pl-3">
								<label for="post" class="">Identification <span class="required">*</span> </label>
								<input class="form-control form-control-lg mb1  {{$errors->first('post') ? 'is-invalid':''}} " id="post" type="text" name="post" value="{{old('post')?old('post'):(isset($edit)?$edit->post:'')}}" placeholder="Enter Identification here.">
								@if($errors->first('post'))
									<div class="text text-danger">
										** {{$errors->first('post')}}
									</div>
								@endif
							</div>
						</div>
						<br>
						<div class="col-md-12 col-sm-12 p-0 pl-3">
							<label for="message">Message<span class="required">*</span> </label> 
							<textarea id="mytextarea" name="message">{!! isset($edit)?$edit->message:(old('message') ?? '') !!}</textarea>
							@if($errors->first('message'))
								<div class="text text-danger">
									*{{$errors->first('message')}}
								</div>
							@endif						
						</div>
				</div>
			</div>
			<!-- / Add New Post Form -->
		</div>
		<div class="col-lg-3 col-md-12">
			<!-- Post Overview -->
			<div class='card card-small mb-3'>
				<div class="card-header border-bottom">
					<h6 class="m-0">Actions</h6>
				</div>
				<div class='card-body p-0'>
					<ul class="list-group list-group-flush">
						<li class="list-group-item p-3">
							<span class="d-flex mb-2">
								<i class="material-icons mr-1">flag</i>
								<strong class="mr-1">Status:</strong>@if(isset($edit))<span class="text text-success" >Created </span>@else <span class="text text-danger" >Not Created</span> @endif
							</span>
						</li>
						<li class="list-group-item d-flex px-3">
							@if(isset($edit))
                                <button id="update" class="btn btn-sm btn-accent ml-auto">
                                    <i class="material-icons">file_copy</i> Update
                                </button>
							@else
							<button id="save" class="btn btn-sm btn-accent ml-auto">
								<i class="material-icons">file_copy</i> Publish
							</button>
							@endif
						</li>
					</ul>
				</div>
			</div>
			<!-- / Post Overview -->
		</div>
	</div>
</form>
	<script type="text/javascript">
		$('#mediaFile').on('change',function(){
			$('#logo').removeClass('d-none').addClass('d-block');
			$('#logo').attr('src',window.URL.createObjectURL(this.files[0]));
    	});
	</script>

@endsection
