@extends('Backend.layouts.app')
@section('content')

<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Social Media Links </h3>
    <a href="{{route('social_media.create')}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 mb-4 text-center">
        <div class="table-responsive p-1">
          <table id="aboutus-table" class="table table-striped table-bordered w-100">
            <thead>
              <tr>
                <th>S.N</th>
                <th>Title</th>
                <th>Link</th>
                <th>Icon</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $k => $l)
              <tr class="">
                <td class="">
                  {{++$k}}
                </td>
                <td class="wordwrap ">{{$l->title}}</td>
                <td class="wordwrap ">{{$l->link_href}}</td>
                <td class="wordwrap"><i class="{{$l->media_icon}} fa-2x"></i></td>
                <td class=""><span class="badge {{$l->status=='Saved'?'badge-success':'badge-danger'}}">{{$l->status}}</span></td>
                <td class="">
                  @if($l->status=='Saved')
                  <a target="_blank" href="{{$l->link_href}}" class="btn btn-primary btn-sm">
                    <i class="fa fa-eye"></i> Preview</a>
                  @endif
                  <a class="btn btn-info btn-sm" href="{{route('social_media.edit',$l->id)}}">{{ $l->status=='Saved'?'Edit':'Edit & Save'}}</a>
                  <a class="btn btn-danger btn-sm" href="{{route('social_media.delete',$l->id)}}">
                    <i class="fa fa-trash"></i>
                  </a>
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#aboutus-table').DataTable({
      "columnDefs": [{
          "width": "40px",
          "targets": 0
        },
        {
          "width": "100px",
          "targets": 1
        },
        {
          "width": "auto",
          "targets": 2
        },
        {
          "width": "50px",
          "targets": 3
        },
        {
          "width": "95px",
          "targets": 4
        }
      ],
    });
  });
</script>
@endsection