@extends('Backend.layouts.app')
@section('content')
<style>
	label{
		font-weight: bold !important;
	}
	span.required{
		color:red;
	}
</style>
	<!-- Page Header -->
	<div class="page-header row no-gutters py-4">
	  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
	    <span class="text-uppercase page-subtitle">Social Media Link</span>
	    <h3 class="page-title">Setup Social Media Links</h3>
	  </div>
	</div>
	<!-- End Page Header -->
	<form class="add-new-post" action="{{isset($edit)?route('social_media.update', $edit->id):route('social_media.store')}}" method="post">
	<div class="row">
	  <div class="col-lg-9 col-md-12">
	    <!-- Add New Post Form -->
	    <div class="card card-small mb-3">
	      <div class="card-body">
	        	@csrf
	        	@if(isset($edit))
	        	<input type="hidden" name="id" value="{{$edit->id}}" />
	        	@endif
	          <input type="hidden" name="status" id="status" />
			  <label for="title">Title <span class="required">*</span></label>
	          <input class="form-control form-control-lg mb-3" id="title" type="text" name="title" value="{{old('title')?old('title'):(isset($edit)?$edit->title:'')}}" placeholder="Your Page Title">
	          @if($errors->first('title'))
	          <div class="alert alert-danger">
	          	{{$errors->first('title')}}
	          </div>
			  @endif
			  <label for="link_href">Link <span class="required">*</span></label>
			  <input class="form-control form-control-lg mb-3" id="link_href" type="text" name="link_href" value="{{old('link_href')?old('link_href'):(isset($edit)?$edit->link_href:'')}}" placeholder="Your Page Title">
	          @if($errors->first('link_href'))
	          <div class="alert alert-danger">
	          	{{$errors->first('link_href')}}
	          </div>
			  @endif
			  <label for="link_href">Icon <span class="required">*</span></label>
			  <select class="form-control form-control-lg mb-3" id="media_icon" type="text" name="media_icon" placeholder="Your Page Title">
				<option value="fab fa-facebook">Facebook</option>
				<option value="fab fa-twitter">Twitter</option>
				<option value="fab fa-instagram">Instagram</option>

			</select>
	          @if($errors->first('media_icon'))
	          <div class="alert alert-danger">
	          	{{$errors->first('media_icon')}}
	          </div>
	          @endif
	      </div>
	    </div>
	    <!-- / Add New Post Form -->
	  </div>
	  <div class="col-lg-3 col-md-12">
	    <!-- Post Overview -->
	    <div class='card card-small mb-3'>
	      <div class="card-header border-bottom">
	        <h6 class="m-0">Actions</h6>
	      </div>
	      <div class='card-body p-0'>
	        <ul class="list-group list-group-flush">
	          <li class="list-group-item p-3">
	          	@if(isset($edit))
	            <span class="d-flex mb-2">
	              <i class="material-icons mr-1">flag</i>
	              <strong class="mr-1">Status:</strong> {{$edit->status}}
	              <!-- <a class="ml-auto" href="#">Edit</a> -->
	            </span>
	            @endif
	            <span class="d-flex">
	              <i class="material-icons mr-1">score</i>
	              <strong class="mr-1">Preview:</strong>
	              <strong class="text-warning">@if(isset($edit) && $edit->status=='Saved')<a target='_blank' href="{{url('/').'/'.$edit->slug.'/'.$edit->url}}"><i class='fa fa-eye'></i> Click</a>@else No @endif</strong>
	            </span>
	          </li>
	          <li class="list-group-item d-flex px-3">
				@if(isset($edit))
				<button type="submit" id="update" class="btn btn-sm btn-accent ml-auto" name="status" value="save">
					<i class="material-icons">file_copy</i> {{$edit->status=='Saved'?'Update':'Save'}}
				</button>
				@else
				<button type="submit" id="draft" class="btn btn-sm btn-outline-accent" name="status" value="draft">
					<i class="material-icons">save</i> Save Draft
				</button>
				<button type="submit" id="save" class="btn btn-sm btn-accent ml-auto"  name="status" value="save">
					<i class="material-icons">file_copy</i> Publish
				</button>
				@endif
	          </li>
	        </ul>
	      </div>
	    </div>
	    <!-- / Post Overview -->
	  </div>
	</div>
</form>
	
	{{-- <script src="{{asset('scripts/app/app-blog-new-post.1.1.0.js')}}"></script> --}}
	

@endsection
