@extends('Backend.layouts.app')
@section('content')
@if(Session::has('msg'))
	<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
	  {{Session::get('msg')}}.
	  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span>
	  </button>
	</div>
@endif
<!-- Page Header -->
<div class="page-header row no-gutters py-4">
	<div class="col-12 col-sm-4 text-center text-sm-left mb-0">
		<span class="text-uppercase page-subtitle">Settings</span>
		<h3 class="page-title">School Configuration</h3>
	</div>
</div>
<!-- End Page Header -->
<form class="row m-0 add-new-post" action="{{isset($edit)?route('vip-message.update', $edit->id):route('vip-message.store')}}" method="post" enctype="multipart/form-data">
{{-- <div class="row"> --}}
	<div class="col-lg-9 col-md-12">
		<!-- Add New Post Form -->
		<div class="card card-small mb-3">
			<div class="card-body">
					@csrf
					@if(isset($edit))
                    <input type="hidden" name="id" value="{{$edit->id}}" />
                    @endif	
                    <input type="hidden" name="profile_image" value="{{ isset($edit)?$edit->profile_image:'empty' }}" />
                    <div class="row col-md-12 mb-5">
                        <div class="col-md-4">
                            <label>Profile Image<span class="required">*</span></label>
                        </div>
                        <div class="col-md-7 card p-3">
                        <img class="{{isset($edit)?'d-block':'d-none'}} m-auto" id="logo" src="{{isset($edit)?asset('vip-profile/'.$edit->profile_image):''}}" width="150px" height="150px"/>
                            <input class="form-control mt-2" type="file" id="mediaFile" name="image"/>
                            @if($errors->first('image'))
                            <div class="text text-danger">
                                * {{$errors->first('image')}}
                            </div>
                            @endif
                        </div>
					</div>			
                    <div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="name" class="">Vip Name <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-1" id="name" type="text" name="name" value="{{old('name')?old('name'):(isset($edit)?$edit->name:'')}}" placeholder="Your School name in english">
							@if($errors->first('name'))
								<div class="text text-danger ">
									{{$errors->first('name')}}
								</div>
							@endif
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="post" class="">Vip Post <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb1" id="post" type="text" name="post" value="{{old('post')?old('post'):(isset($edit)?$edit->post:'')}}" placeholder="Your School name in nepali">
							@if($errors->first('post'))
								<div class="text text-danger">
									{{$errors->first('post')}}
								</div>
							@endif
						</div>
					</div>
                    <div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="phone_number">Phone Number</label>
							<input class="form-control form-control-lg mb-1" id="phone_number" type="text" name="phone_number" value="{{old('phone_number')?old('phone_number'):(isset($edit)?$edit->phone_number:'')}}" placeholder="Your school phone number">
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for=email_address>Email Address</label>
							<input class="form-control form-control-lg mb-1 " id="email_address" type="text" name="email_address" value="{{old('email_address')?old('email_address'):(isset($edit)?$edit->email_address:'')}}" placeholder="Your School email address">
						</div>
                    </div>
					<div class="col-md-12 col-sm-12 p-0 pl-3">
                        <label for="message">Vip Message<span class="required">*</span> </label> 
						<textarea id="mytextarea" name="message">{!! isset($edit)?$edit->message:(old('message') ?? '') !!}</textarea>
                        @if($errors->first('message'))
							<div class="text text-danger">
								*{{$errors->first('message')}}
							</div>
						@endif						
					</div>
			</div>
		</div>
		<!-- / Add New Post Form -->
	</div>
	<div class="col-lg-3 col-md-12">
		<!-- Post Overview -->
		<div class='card card-small mb-3'>
			<div class="card-header border-bottom">
				<h6 class="m-0">Actions</h6>
			</div>
			<div class='card-body p-0'>
				<ul class="list-group list-group-flush">
					<li class="list-group-item p-3">
						<span class="d-flex mb-2">
							<i class="material-icons mr-1">flag</i>
							<strong class="mr-1">Status:</strong>@if(isset($edit))<span class="text text-success" >Created </span>@else <span class="text text-danger" >Not Created</span> @endif
						</span>
					</li>
					<li class="list-group-item d-flex px-3">
						@if(isset($edit))
						<button type="submit" name="status" value="save" id="update" class="btn btn-sm btn-accent ml-auto">
							<i class="material-icons">file_copy</i> Update
						</button>
						@else
						<button type="submit" name="status" value="save" id="save" class="btn btn-sm btn-accent ml-auto">
							<i class="material-icons">file_copy</i> Publish
						</button>
						@endif
					</li>
				</ul>
			</div>
		</div>
		<!-- / Post Overview -->
	</div>
</form>

<script type="text/javascript">
    $('#mediaFile').on('change',function(){
        $('#logo').removeClass('d-none').addClass('d-block');
        $('#logo').attr('src',window.URL.createObjectURL(this.files[0]));
    });
</script>

@endsection