@extends('Backend.layouts.app')
@section('content')
@if(Session::has('msg'))
	<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
	  {{Session::get('msg')}}.
	  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span>
	  </button>
	</div>
@endif
<!-- Page Header -->
<div class="page-header row no-gutters py-4">
	<div class="col-12 col-sm-4 text-center text-sm-left mb-0">
		<span class="text-uppercase page-subtitle">Settings</span>
		<h3 class="page-title">School Configuration</h3>
	</div>
</div>
<!-- End Page Header -->
<form class="row m-0 add-new-post" action="{{ isset($edit) ? route('school-config.update', $edit->id): route('school-config.store') }}" method="post" enctype="multipart/form-data">
{{-- <div class="row"> --}}
	<div class="col-lg-9 col-md-12">
		<!-- Add New Post Form -->
		<div class="card card-small mb-3">
			<div class="card-body">
					@csrf
					@if(isset($edit))
                    <input type="hidden" name="id" value="{{$edit->id}}" />
                    @endif	
                    <input type="hidden" name="logo" value="{{ isset($edit)?$edit->logo:'empty' }}" />
                    <div class="row col-md-12 mb-5">
                        <div class="col-md-4">
                            <label>Logo Image<span class="required">*</span></label>
                        </div>
                        <div class="col-md-7 card p-3">
                        <img class="{{isset($edit)?'d-block':'d-none'}} m-auto" id="logo" src="{{isset($edit)?asset('logo/'.$edit->logo):''}}" width="150px" height="150px"/>
                            <input class="form-control mt-2" type="file" id="mediaFile" name="image"/>
                            @if($errors->first('image'))
                            <div class="text text-danger">
                                * {{$errors->first('image')}}
                            </div>
                            @endif
                        </div>
                    </div>			
                    <div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="name_en" class="">Name(English) <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-1" id="name_en" type="text" name="name_en" value="{{old('name_en')?old('name_en'):(isset($edit)?$edit->name_en:'')}}" placeholder="Your School name in english">
							@if($errors->first('name_en'))
								<div class="text text-danger ">
									{{$errors->first('name_en')}}
								</div>
							@endif
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="name_np" class="">Name(Nepali) <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb1" id="name_np" type="text" name="name_np" value="{{old('name_np')?old('name_np'):(isset($edit)?$edit->name_np:'')}}" placeholder="Your School name in nepali">
							@if($errors->first('name_np'))
								<div class="text text-danger">
									{{$errors->first('name_np')}}
								</div>
							@endif
						</div>
					</div>
                    <div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="phone_number">Phone Number <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-1" id="phone_number" type="text" name="phone_number" value="{{old('phone_number')?old('phone_number'):(isset($edit)?$edit->phone_number:'')}}" placeholder="Your school phone number">
							@if($errors->first('phone_number'))
								<div class="text text-danger">
									{{$errors->first('phone_number')}}
								</div>
							@endif
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="phone_number2">Phone Number (alternative) </label>
							<input class="form-control form-control-lg mb-1" id="phone_number2" type="text" name="phone_number2" value="{{old('phone_number2')?old('phone_number2'):(isset($edit)?$edit->phone_number2:'')}}" placeholder="Your School phone number (alternative).">
							@if($errors->first('phone_number2'))
								<div class="text text-danger">
									{{$errors->first('phone_number2')}}
								</div>
							@endif
						</div>
					</div>
                    <div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for=email_address>Email Address <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-1 " id="email_address" type="text" name="email_address" value="{{old('email_address')?old('email_address'):(isset($edit)?$edit->email_address:'')}}" placeholder="Your School email address">
							@if($errors->first('email_address'))
								<div class="text text-danger">
									{{$errors->first('email_address')}}
								</div>
							@endif
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="address">Address <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-1" id="address" type="text" name="address" value="{{old('address')?old('address'):(isset($edit)?$edit->address:'')}}" placeholder="Your School address Title">
							@if($errors->first('address'))
								<div class="text text-danger">
									{{$errors->first('address')}}
								</div>
							@endif
						</div>
					</div>
                    <div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="principal_name">Principal Name <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-1" id="principal_name" type="text" name="principal_name" value="{{old('principal_name')?old('principal_name'):(isset($edit)?$edit->principal_name:'')}}" placeholder="Principal Name">
							@if($errors->first('principal_name'))
								<div class="text text-danger">
									{{$errors->first('principal_name')}}
								</div>
							@endif
						</div>						
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label>Map Iframe Location </label> 
							@if($errors->first('location_iframe'))
								<div class="text text-danger">
									*{{$errors->first('location_iframe')}}
								</div>
							@endif 
							<textarea class="form-control " name="location_iframe">{!! isset($edit)?$edit->location_iframe:(old('location_iframe') ?? '') !!}</textarea>
							
						</div>
                    </div>
					<br/>
					{{-- <div class="col-md-6 col-sm-6 p-0 pl-3">
						<label for="latitude">Latitude </label>
						<input class="form-control form-control-lg mb-1" id="latitude" type="text" name="latitude" value="{{old('latitude')?old('latitude'):(isset($edit)?$edit->latitude:'')}}" placeholder="Your School Location Latitude">
						@if($errors->first('latitude'))
							<div class="text text-danger">
								{{$errors->first('latitude')}}
							</div>
						@endif
					</div>
					<div class="col-md-6 col-sm-6 p-0 pl-3">
						<label for="longitude">Longitude </label>
						<input class="form-control form-control-lg mb-1" id="longitude" type="text" name="longitude" value="{{old('longitude')?old('longitude'):(isset($edit)?$edit->longitude:'')}}" placeholder="Your School Location Longitude">
						@if($errors->first('longitude'))
							<div class="text text-danger">
								{{$errors->first('longitude')}}
							</div>
						@endif
					</div> --}}
                    <div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="pan_no">Pan Number </label>
							<input class="form-control form-control-lg mb-1" id="pan_no" type="text" name="pan_no" value="{{old('pan_no')?old('pan_no'):(isset($edit)?$edit->pan_no:'')}}" placeholder="Your School Pan Number">
							@if($errors->first('pan_no'))
								<div class="text text-danger">
									{{$errors->first('pan_no')}}
								</div>
							@endif
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label for="reg_no">Registration Number</label>
							<input class="form-control form-control-lg mb-1" id="reg_no" type="text" name="reg_no" value="{{old('reg_no')?old('reg_no'):(isset($edit)?$edit->reg_no:'')}}" placeholder="Your School Registration number">
							@if($errors->first('reg_no'))
								<div class="text text-danger">
									{{$errors->first('reg_no')}}
								</div>
							@endif
						</div>
                    </div>
					<div class="col-md-12 col-sm-12 p-0 pl-3">
                        <label>About your school<span class="required">*</span> </label> 
                        @if($errors->first('description'))
							<div class="text text-danger">
								*{{$errors->first('description')}}
							</div>
						@endif 
						<textarea id="mytextarea" name="description">{!! isset($edit)?$edit->description:(old('description') ?? '') !!}</textarea>
						
					</div>
			</div>
		</div>
		<!-- / Add New Post Form -->
	</div>
	<div class="col-lg-3 col-md-12">
		<!-- Post Overview -->
		<div class='card card-small mb-3'>
			<div class="card-header border-bottom">
				<h6 class="m-0">Actions</h6>
			</div>
			<div class='card-body p-0'>
				<ul class="list-group list-group-flush">
					<li class="list-group-item p-3">
						<span class="d-flex mb-2">
							<i class="material-icons mr-1">flag</i>
							<strong class="mr-1">Status:</strong>@if(isset($edit))<span class="text text-success" >Created </span>@else <span class="text text-danger" >Not Created</span> @endif
						</span>
					</li>
					<li class="list-group-item d-flex px-3">
						@if(isset($edit))
						<button type="submit" id="update" class="btn btn-sm btn-accent ml-auto">
							<i class="material-icons">file_copy</i> Update
						</button>
						@else
						<button type="submit" id="save" class="btn btn-sm btn-accent ml-auto">
							<i class="material-icons">file_copy</i> Publish
						</button>
						@endif
					</li>
				</ul>
			</div>
		</div>
		<!-- / Post Overview -->
	</div>
</form>
{{-- </div> --}}

<script type="text/javascript">
$('#mediaFile').on('change',function(){
            $('#logo').removeClass('d-none').addClass('d-block');
            $('#logo').attr('src',window.URL.createObjectURL(this.files[0]));
        });
	// $(function() {
	// 	$('#save').on('click', function(e) {
	// 		e.preventDefault();
	// 		$('form').submit();
	// 	})
	// 	$('#update').on('click', function(e) {
	// 		e.preventDefault()
	// 		$('form').submit();

	// 	});
	// });
</script>

@endsection