@extends('Backend.layouts.app')
@section('content')
	@if(Session::has('msg'))
	<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
	  {{Session::get('msg')}}.
	  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
		<span aria-hidden="true">&times;</span>
	  </button>
	</div>
	@endif
	<!-- Page Header -->
	<div class="page-header row no-gutters py-4">
	  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
	    <span class="text-uppercase page-subtitle">Header Settings</span>
	    <h3 class="page-title">Setup Header</h3>
	  </div>
	</div>
	<!-- End Page Header -->
	<div class="row">
	  <div class="col-lg-8 col-md-12">
	    <!-- Add New Post Form -->
	    <div class="card card-small mb-3">
	      <div class="card-body">
	        <form class="add-new-post" action="{{isset($header)?route('settings.header.update'):route('settings.header.store')}}" method="post" enctype="multipart/form-data">
	        	@csrf
	        	@if(isset($edit))
	        	<input type="hidden" name="id" value="{{$edit->id}}" />
	        	@endif
                <input type="hidden" name="status" id="status" />
                <div class="row form-group">
                    <div class="col-md-4">
                        <label>Logo Image<span class="required">*</span></label>
                    </div>
                    <div class="col-md-7 card p-3">
					<img class="{{isset($header[1])?'d-block':'d-none'}} m-auto" id="logo" src="{{isset($header[1])?asset('logo/'.$header[1]->value):''}}" width="150px" height="150px"/>
                        <input class="form-control mt-2" type="file" id="mediaFile" name="logo"/>
                        @if($errors->first('logo'))
                        <div class="text text-danger">
                            * {{$errors->first('logo')}}
                        </div>
                        @endif
                    </div>
                </div>
                <label>Header Content<span class="required">*</span></label>
                <textarea id="mytextarea" name="content">{{ isset($header[0])?$header[0]->value:(old('content')??'') }}</textarea>
                @if($errors->first('content'))
                <div class="text text-danger">
                    * {{$errors->first('content')}}
                </div>
	          @endif
	        </form>
	      </div>
	    </div>
	    <!-- / Add New Post Form -->
	  </div>
	  <div class="col-lg-4 col-md-12">
	    <!-- Post Overview -->
	    <div class='card card-small mb-3'>
	      <div class="card-header border-bottom">
	        <h6 class="m-0">Actions</h6>
	      </div>
	      <div class='card-body p-0'>
	        <ul class="list-group list-group-flush">
	          <li class="list-group-item p-3">
	          	@if(isset($header))
	            <span class="d-flex mb-2">
	              <i class="material-icons mr-1">flag</i>
	              <strong class="mr-1">Status:</strong> created
	              <!-- <a class="ml-auto" href="#">Edit</a> -->
	            </span>
	            @endif
	          </li>
	          <li class="list-group-item d-flex px-3">
	          	@if(isset($header))
	            <button id="update" class="btn btn-sm btn-accent ml-auto">
	              <i class="material-icons">file_copy</i> Update
	            </button>
	          	@else
	            <button id="save" class="btn btn-sm btn-accent ml-auto">
	              <i class="material-icons">file_copy</i> Publish
	          	</button>
	          	@endif
	          </li>
	        </ul>
	      </div>
	    </div>
	    <!-- / Post Overview -->
	  </div>
	</div>
    {{-- {{-- <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/js/fileinput.js" type="text/javascript"></script> --}}
    {{-- <script src="{{asset('scripts/app/app-blog-new-post.1.1.0.js')}}"></script> --}}
	<script type="text/javascript">
		$('#mediaFile').on('change',function(){
            $('#logo').removeClass('d-none').addClass('d-block');
            $('#logo').attr('src',window.URL.createObjectURL(this.files[0]));
        });
		$(function(){
			$('#save').on('click', function(e){
				$('#status').val('save');
				$('form').submit();
			})
			$('#draft').on('click', function(e){
				$('#status').val('draft');
				$('form').submit();
			})
			$('#update').on('click', function(e){
				$('#status').val('save');
				// $('form')
				$('form').submit();

			});
		});

	</script>

@endsection
