@extends('Backend.layouts.app')
@section('content')
<script>
	tinymce.init({
		selector: '#mytextarea',
		plugins: ' table image link lists media paste spellchecker fullscreen imagetools',
		toolbar: 'undo redo | link image | code | table | fullpage fullscreen | quickbars ',
		file_picker_types: 'file image media',
		file_picker_callback: function (cb, value, meta) {
			var input = document.createElement('input');
			input.setAttribute('type', 'file');
			input.setAttribute('accept', 'image/*');
			input.onchange = function () {
			var file = this.files[0];

			var reader = new FileReader();
			reader.onload = function () {
				var id = 'blobid' + (new Date()).getTime();
				var blobCache =  tinymce.activeEditor.editorUpload.blobCache;
				var base64 = reader.result.split(',')[1];
				var blobInfo = blobCache.create(id, file, base64);
				blobCache.add(blobInfo);
				cb(blobInfo.blobUri(), { title: file.name });
			};
			reader.readAsDataURL(file);
		};
		input.click();
		}
	});
</script>
<style>
.tox.tox-tinymce{
	height: 300px !important;
}
label{
	font-weight: bold !important;
}
span.required{
	color:red;
}
</style>
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
	{{Session::get('msg')}}.
	<button type="button" class="close" data-dismiss="alert" aria-label="Close">
	<span aria-hidden="true">&times;</span>
	</button>
</div>
@endif
<!-- Page Header -->
<div class="page-header row no-gutters py-4">
	<div class="col-12 col-sm-4 text-center text-sm-left mb-0">
	<span class="text-uppercase page-subtitle">Footer Settings</span>
	<h3 class="page-title">Setup Footer</h3>
	</div>
</div>
<!-- End Page Header -->
<div class="row">
	<div class="col-lg-8 col-md-12">
	<!-- Add New Post Form -->
	<div class="card card-small mb-3">
		<div class="card-body">
		<form class="add-new-post" action="{{isset($footer)?route('settings.footer.update'):route('settings.footer.store')}}" method="post" enctype="multipart/form-data">
			@csrf
			<label>Footer Content<span class="required">*</span></label>
			<textarea id="mytextarea" name="content">{{ isset($footer)?$footer->value:(old('content') ?? '')}}</textarea>
			@if($errors->first('content'))
			<div class="text text-danger">
				* {{$errors->first('content')}}
			</div>
			@endif
		</form>
		</div>
	</div>
	<!-- / Add New Post Form -->
	</div>
	<div class="col-lg-4 col-md-12">
	<!-- Post Overview -->
	<div class='card card-small mb-3'>
		<div class="card-header border-bottom">
		<h6 class="m-0">Actions</h6>
		</div>
		<div class='card-body p-0'>
		<ul class="list-group list-group-flush">
			<li class="list-group-item p-3">
			@if(isset($footer))
			<span class="d-flex mb-2">
				<i class="material-icons mr-1">flag</i>
				<strong class="mr-1">Status:</strong> created
				<!-- <a class="ml-auto" href="#">Edit</a> -->
			</span>
			@endif
			</li>
			<li class="list-group-item d-flex px-3">
			@if(isset($footer))
			<button id="update" class="btn btn-sm btn-accent ml-auto">
				<i class="material-icons">file_copy</i> Update
			</button>
			@else
			<button id="save" class="btn btn-sm btn-accent ml-auto">
				<i class="material-icons">file_copy</i> Publish
			</button>
			@endif
			</li>
		</ul>
		</div>
	</div>
	<!-- / Post Overview -->
	</div>
</div>
<script type="text/javascript">
	$(function(){
		$('#save').on('click', function(e){
			$('form').submit();
		})
		$('#update').on('click', function(e){
			$('form').submit();
		});
	});
</script>

@endsection
