@extends('Backend.layouts.app')
@section('content')
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Notice Page</h3>
    <a href="{{route('notices.create')}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Notice</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
       <div class="table-responsive p-1">
          <table id="notice-table" class="table table-striped table-bordered w-100">
            <thead>
              <tr>
                <th>Date</th>
                <th>Notice Title</th>
                <th>Files</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td class="">
                  <div>{{ date('Y', strtotime($l->created_at)) }}</div>
                  <div>{{ date('m-d', strtotime($l->created_at)) }}</div>
                </td>
                <td>{{$l->title}}</td>
                <td>
                  @foreach($l->upload as $u)
                  <a href="{{asset('/').$u->filebasepath.'/'.$u->filepath.'/'.$u->filename}}"><button class="btn btn-primary m-1">{{$u->filename}}</button></a>
                  @endforeach
                </td>
                <td><span class="badge {{$l->status=='Saved'?'badge-success':'badge-danger'}}">{{$l->status}}</span></td>
                <td class="col-md-3 col-sm-4">
                  @if($l->status=='Saved')
                  <a class="btn btn-sm btn-primary" target="_blank" href="#" class="text-primary" title="Preview"><i class="fa fa-eye fa-fw"></i></a>
                  @endif
                  <a class="btn btn-sm btn-info" href="{{route('notices.edit', $l->id)}}"><i class="fa fa-edit fa-fw"></i></a>
                  <!-- onclick="$('form#update').submit(); -->
                  <a class="btn btn-sm btn-danger" href="{{route('notices.delete',$l->id)}}"><i class="fa fa-trash fa-fw" title="Delete"></i> </a></td>
                <form id="update" action="{{route('notices.update', $l->id)}}" method="post">
                  @csrf
                </form>
              </tr>
              @endforeach
            </tbody>
          </table>
       </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#notice-table').DataTable({
      "columnDefs": [{
          "width": "40px",
          "targets": 0
        },
        {
          "width": "20%",
          "targets": 1
        },
        {
          "width": "auto",
          "targets": 2
        },
        {
          "width": "50px",
          "targets": 3
        },
        {
          "width": "100px",
          "targets": 4
        }
      ],
    });
  });
</script>
@endsection