@extends('Backend.layouts.app')
@section('content')
	<!-- Page Header -->
	<div class="page-header row no-gutters py-4">
	  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
	    <span class="text-uppercase page-subtitle">Information Pages</span>
	    <h3 class="page-title">Add New Page</h3>
	  </div>
	</div>
	<!-- End Page Header -->
	{{-- <div class="row"> --}}
	<form class="row add-new-post" action="{{isset($edit)?route('information.update', $edit->id):route('information.store')}}" method="post">
	  <div class="col-lg-9 col-md-12">
	    <!-- Add New Post Form -->
	    <div class="card card-small mb-3">
	      <div class="card-body">
	        	@csrf
	        	@if(isset($edit))
	        	<input type="hidden" name="id" value="{{$edit->id}}" />
	        	@endif
	          <input type="hidden" name="status" id="status" />
	          <input class="form-control form-control-lg mb-3" id="title" type="text" name="title" value="{{old('title')?old('title'):(isset($edit)?$edit->title:'')}}" placeholder="Your Page Title">
	          @if($errors->first('title'))
	          <div class="alert alert-danger">
	          	{{$errors->first('title')}}
	          </div>
	          @endif       
			  <textarea id="mytextarea" name="content">{!! isset($edit)?$edit->content:'' !!}</textarea>
	      </div>
	    </div>
	    <!-- / Add New Post Form -->
	  </div>
	  <div class="col-lg-3 col-md-12">
	    <!-- Post Overview -->
	    <div class='card card-small mb-3'>
	      <div class="card-header border-bottom">
	        <h6 class="m-0">Actions</h6>
	      </div>
	      <div class='card-body p-0'>
	        <ul class="list-group list-group-flush">
	          <li class="list-group-item p-3">
	          	@if(isset($edit))
	            <span class="d-flex mb-2">
	              <i class="material-icons mr-1">flag</i>
	              <strong class="mr-1">Status:</strong> {{$edit->status}}
	              <!-- <a class="ml-auto" href="#">Edit</a> -->
	            </span>
	            @endif
	            <span class="d-flex">
	              <i class="material-icons mr-1">score</i>
	              <strong class="mr-1">Preview:</strong>
	              <strong class="text-warning">@if(isset($edit) && $edit->status=='Saved')<a target='_blank' href="{{url('/').'/'.$edit->slug.'/'.$edit->url}}"><i class='fa fa-eye'></i> Click</a>@else No @endif</strong>
	            </span>
	          </li>
	          <li class="list-group-item d-flex px-3">
	          	@if(isset($edit))
	            <button id="update" name="status" value="save" class="btn btn-sm btn-accent ml-auto">
	              <i class="material-icons">file_copy</i> {{$edit->status=='Saved'?'Update':'Save'}}
	            </button>
	          	@else	          	
	            <button id="draft" name="status" value="draft" class="btn btn-sm btn-outline-accent">
	              <i class="material-icons">save</i> Save Draft
	          	</button>
	            <button id="save" name="status" value="save" class="btn btn-sm btn-accent ml-auto">
	              <i class="material-icons">file_copy</i> Publish
	          	</button>
	          	@endif
	          </li>
	        </ul>
	      </div>
	    </div>
	    <!-- / Post Overview -->
	  </div>
	</form>
	<script type="text/javascript">

	</script>
@endsection
