@extends('Backend.layouts.app')
@section('content')
<style type="text/css">
  table .img-thumbnail {
    background-color: #f2f2f2 !important;
    height: 100px;
    width: 200px;
    padding: 0 2px 2px 0;
  }
</style>
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Image Slider Page</h3>
    <a href="{{route('image-slider.create')}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Album</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
      <div class="table-responsive p-1">
          <table id="gallery-table" class="table table-striped table-bordered w-100">
            <thead>
              <tr>
                <th>Date</th>
                <th>Slider Title</th>
                <th>Slider Image</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td class="">
                  <div>{{ date('Y-m-d', strtotime($l->created_at)) }}</div>
                </td>
                <td>{{$l->title}}</td>
                <td><img src="{{asset('/image-slider').'/'.$l->banner_image}}" alt="{{$l->title}}" class="img-thumbnail" width="200" height="100"></td>
                <td class="col-md-3 col-sm-4">
                  <a class="btn btn-sm btn-info" href="{{route('image-slider.edit', $l->id)}}"><i class="fa fa-edit"></i></a>
                  <!-- onclick="$('form#update').submit(); -->
                  <a class="btn btn-sm btn-danger" href="{{route('image-slider.delete',$l->id)}}"><i class="fa fa-trash" title="Delete"></i> </a></td>
                <form id="update" action="{{route('image-slider.update', $l->id)}}" method="post">
                  @csrf
                </form>
              </tr>
              @endforeach
            </tbody>
          </table>
      </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#gallery-table').DataTable({
      "columnDefs": [{
          "width": "15%",
          "targets": 0
        },
        {
          "width": "20%",
          "targets": 1
        },
        {
          "width": "40%",
          "targets": 2
        },
        {
          "width": "15%",
          "targets": 3
        },
      ],
    });
  });
</script>
@endsection