@extends('Backend.layouts.app')
@section('content')
{{-- @dd($edit) --}}
<link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/css/fileinput.css" media="all" rel="stylesheet" type="text/css"/>
<div class="page-header row no-gutters py-4">
	<div class="col-12 col-sm-4 text-center text-sm-left mb-0">
	  <span class="text-uppercase page-subtitle">Image Slider Page</span>
	  <h3 class="page-title">Add New Image Slider</h3>
	</div>
  </div>
  <form role="form" action="{{ isset($edit)?route('image-slider.update', $edit->id):route('image-slider.store') }}" method="post" id="form" class="oas-form-inline" enctype="multipart/form-data">
  <div class="row">
	<div class="col-lg-9 col-md-12">
		<!-- Add New Post Form -->
		<div class="card card-small mb-3">   
			<div class="card-body">
				{{-- <input type="hidden" value="" name="id" id="id"> --}}
				<input type="hidden" name="_token" id="_token" value="<?php echo csrf_token();?>">
					<div class="form-group">
						<label for="title">Title <span class="text-danger">*</span></label>
						<div class="col-md-8">
						<input type="text" name='title' id='title' class="form-control" value="{{ isset($edit)?$edit->title:(old('title') ?? '') }}" >
							@if($errors->first('title'))
								<div class="text text-danger col-md-12 mt-2">{{ $errors->first('title')}}</div>
							@endif
						</div>
					</div>
					@if(!isset($edit))
						<div class="form-group">
							<label>Image Slider <span class="required">*</span> </label>
							<div class="file-loading">
								<input id="file-1" type="file" name="banner_image[]" class="file" data-overwrite-initial="true" data-min-file-count="1" accept=".jpeg, .jpg, .png, .gif, .bmp">
							</div>                            
							@if($errors->first('banner_image.*'))
							<div class="text-danger mb-2">* 
								{{$errors->first('banner_image.*')}}
							</div>
							@elseif($errors->first('banner_image'))
							<div class="text-danger mb-2">* 
								{{$errors->first('banner_image')}}
							</div>                              
							@endif
						</div>
					@endif
			</div>
		</div>
	</div>
	
	<div class="col-lg-3 col-md-12">
		<!-- Post Overview -->
		<div class='card card-small mb-3'>
		<div class="card-header border-bottom">
			<h6 class="m-0">Actions</h6>
		</div>
		<div class='card-body p-0'>
			<ul class="list-group list-group-flush">
			<li class="list-group-item p-3">
				<span class="d-flex mb-2">
				<i class="material-icons mr-1">flag</i>
				<strong class="mr-1">Status:</strong>
				<strong class="{{isset($edit)?'text-success':'text-warning'}}"> {{isset($edit)?'Saved':'Not Created'}}</strong>
				</span>
			</li>
			<li class="list-group-item d-flex px-3">
				<button id="update" class="btn btn-sm btn-outline-accent ml-auto" name="status" value="save">
				<i class="material-icons">save</i>{{isset($edit)?'Update':'Publish'}}
				</button>
			</li>
			</ul>
		</div>
		</div>
		<!-- / Post Overview -->
	</div>
  </div>
</form>
@if(!isset($edit))
	<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/js/fileinput.js" type="text/javascript"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/themes/fa/theme.js" type="text/javascript"></script>
@endif
<script type="text/javascript">
	// $("#file-1").fileinput();
	var edit =' {{isset($edit)}}';
	console.log(edit)
	if(edit == false){
		console.log(edit)
		$("#file-1").fileinput({
			theme: 'fa',
			uploadUrl: "{{route('gallery.featuredImage')}}",
			allowedFileExtensions: ['jpg', 'png', 'gif'],
			overwriteInitial: false,
			maxFileSize:2000,
			maxFilesNum: 10,
			slugCallback: function (filename) {
			// console.log(filename);
			$('.kv-file-upload').attr('title','Set as Featured Image')
				$('.kv-file-upload').html('<i class="fa fa-star text-warning"></i>');
				$(this).val(filename);
				return filename.replace('(', '_').replace(']', '_');
			}

		});
	}

</script>
@endsection