@extends('Backend.layouts.app')
@section('content')
<style type="text/css">
  table .img-thumbnail {
    background-color: #f2f2f2 !important;
    height: 50px;
    width: 50px;
    padding: 0 2px 2px 0;
  }
</style>
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Gallery Page</h3>
    <a href="{{route('gallery.create')}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Album</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
      <div class="table-responsive p-1">
          <table id="gallery-table" class="table table-striped table-bordered w-100">
            <thead>
              <tr>
                <th>Date</th>
                <th>Album name</th>
                <th>Images</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td class="">
                  <div>{{ date('Y-m-d', strtotime($l->created_at)) }}</div>
                </td>
                <td>{{$l->title}}</td>
                <td>
                  @foreach($l->upload as $k => $u)
                  @if($k < 3)
                    <img src="{{asset('/').$u->filebasepath.'/'.$u->filepath.'/'.$u->filename}}" alt="{{$u->filename}}" class="img-thumbnail" width="70" height="70">
                  @endif
                  @endforeach
                  @if(count($l->upload) > 3)
                    <div class="badge badge-info py-2">  {{'+ '.(count($l->upload) - 3)}} </div>
                  @endif
                </td>
                <td><span class="badge {{$l->status=='Saved'?'badge-success':'badge-danger'}}">{{$l->status}}</span></td>
                <td class="col-md-3 col-sm-4">
                  @if($l->status=='Saved')
                  <a  class="btn btn-sm btn-primary" target="_blank" href="#" title="Preview"><i class="fa fa-eye"></i></a>
                  @endif
                  <a class="btn btn-sm btn-info" href="{{route('gallery.edit', $l->id)}}"><i class="fa fa-edit"></i></a>
                  <!-- onclick="$('form#update').submit(); -->
                  <a class="btn btn-sm btn-danger" href="{{route('gallery.delete',$l->id)}}"><i class="fa fa-trash" title="Delete"></i> </a></td>
                <form id="update" action="{{route('gallery.update', $l->id)}}" method="post">
                  @csrf
                </form>
              </tr>
              @endforeach
            </tbody>
          </table>
      </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#gallery-table').DataTable({
      "columnDefs": [{
          "width": "15%",
          "targets": 0
        },
        {
          "width": "20%",
          "targets": 1
        },
        {
          "width": "auto",
          "targets": 2
        },
        {
          "width": "5%",
          "targets": 3
        },
        {
          "width": "20%",
          "targets": 4
        },
      ],
    });
  });
</script>
@endsection