@extends('Backend.layouts.app')
@section('content')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/css/fileinput.css" media="all" rel="stylesheet" type="text/css"/>

    <style type="text/css">
        label{
            font-weight: bold !important;
        }
        span.required{
            color:red;
        }
        .main-section{

            margin:0 auto;

            padding: 20px;

            margin-top: 100px;

            background-color: #fff;

            box-shadow: 0px 0px 20px #c1c1c1;

        }
        .added-images .img-thumbnail{
          height:95px;
          width:95px;
          /*padding:10px;
          background: #000;
          margin: 5px;*/
        }

        .fileinput-remove,

        .fileinput-upload{

            display: none;

        }
        .added-images .file-preview-frame{
          width: 110px !important;
          height: 130px !important;
          margin:5px !important;
          padding:4px !important;
          display: inline-block !important;
        }
        .added-images .kv-file-content{
          width: 100px !important;
          height: 100px !important;
        }
        .added-images .file-footer-buttons button{
          height: 20px !important;
          line-height: 0px !important;
          margin-bottom: 5px !important;
        }
        .added-images .file-footer-buttons i{
          font-size:10px !important;
        }
        .close {
          position: absolute;
          font-size:13px;
          margin-left: -20px;
          /*background: #000;*/
          color:red;
          opacity:1 !important;
        }

    </style>

    @if(Session::has('msg'))
    <div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert" >
       {{Session::get('msg')}}.
      <button type="button" class="close" data-dismiss="alert" aria-label="Close">
        <span aria-hidden="true">&times;</span>
      </button>
    </div>
    @endif
    <div class="page-header row no-gutters py-4">
      <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
        <span class="text-uppercase page-subtitle">Gallery Page</span>
        <h3 class="page-title">Add New Album</h3>
      </div>
    </div>
    <form class="add-new-post" action="{{isset($edit)?route('gallery.update', $edit->id):route('gallery.store')}}" method="post" enctype="multipart/form-data">
    <div class="row">
        <div class="col-lg-9 col-md-12">
            <!-- Add New Post Form -->
            <div class="card card-small mb-3">   
                <div class="card-body">

                        @csrf
                        @if(isset($edit))
                        <input type="hidden" id="id" name="id" value="{{$edit->id}}" />
                        @endif
                        <input type="hidden" name="status" id="status" />
                        <label>Album Title <span class="required">*</span> </label>
                        <input class="form-control form-control-lg mb-3" id="title" type="text" name="title" value="{{old('title')?old('title'):(isset($edit)?$edit->title:'')}}" placeholder="Album Title" data-preview-file-type="text">
                          @if($errors->first('title'))
                          <div class="text-danger mb-2">* 
                            {{$errors->first('title')}}
                          </div>
                          @endif
                        <div class="form-group">
                            <label>Images <span class="required">*</span> </label>
                            <div class="file-loading">
                                <input id="file-1" type="file" name="file[]" class="file" data-overwrite-initial="true" multiple data-min-file-count="1" accept=".jpeg, .jpg, .png, .gif, .bmp">
                            </div>                            
                              @if($errors->first('file.*'))
                              <div class="text-danger mb-2">* 
                                {{$errors->first('file.*')}}
                              </div>
                              @elseif($errors->first('file'))
                              <div class="text-danger mb-2">* 
                                {{$errors->first('file')}}
                              </div>                              
                              @endif
                        </div>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-12">
            <!-- Post Overview -->
            <div class='card card-small mb-3'>
              <div class="card-header border-bottom">
                <h6 class="m-0">Actions</h6>
              </div>
              <div class='card-body p-0'>
                <ul class="list-group list-group-flush">
                  <li class="list-group-item p-3">
                    <span class="d-flex mb-2">
                      <i class="material-icons mr-1">flag</i>
                      <strong class="mr-1">Status:</strong>
                      <strong class="text-warning"> {{isset($edit)?$edit->status:'Not saved'}}</strong>
                    </span>
                    <span class="d-flex">
                      <i class="material-icons mr-1">score</i>
                      <strong class="mr-1">Preview:</strong>
                      <strong class="text-warning">@if(isset($edit) && $edit->status=='Saved')<a target='_blank' href="{{url('/').'/'.$edit->slug.'/'.$edit->group_id}}"><i class='fa fa-eye'></i> Click</a>@else No @endif</strong>
                    </span>
                  </li>
                  <li class="list-group-item d-flex px-3">
                    @if(isset($edit))
                    <button type="submit" id="update" class="btn btn-sm btn-accent ml-auto" name="status" value="save">
                        <i class="material-icons">file_copy</i> {{$edit->status=='Saved'?'Update':'Save'}}
                    </button>
                    @else
                    <button type="submit" id="draft" class="btn btn-sm btn-outline-accent" name="status" value="draft">
                        <i class="material-icons">save</i> Save Draft
                    </button>
                    <button type="submit" id="save" class="btn btn-sm btn-accent ml-auto"  name="status" value="save">
                        <i class="material-icons">file_copy</i> Publish
                    </button>
                    @endif
                  </li>
                </ul>
              </div>
            </div>
            <!-- / Post Overview -->
            @if(isset($edit))
              <div class='card card-small mb-3'>
                <div class="card-header border-bottom">
                  <h6 class="m-0">Added Images</h6>
                </div>
                <div class='card-body p-0 added-images'>
                  @foreach($edit->upload as $e)
                  <div class="file-preview-frame krajee-default  kv-preview-thumb">
                    <div class="kv-file-content">
                      <a href="{{asset('/').$e->filebasepath.'/'.$e->filepath.'/'.$e->filename}}" target="_blank">
                        <img class="img-thumbnail" src="{{asset('/').$e->filebasepath.'/'.$e->filepath.'/'.$e->filename}}">
                      </a>
                    </div>
                    <div class="file-thumbnail-footer">
                      <div class="file-actions">
                        <div class="file-footer-buttons">
                          <a href="{{route('image.delete', $e->id)}}">
                            <button type="button" class="kv-file-remove btn btn-kv btn-default btn-outline-secondary" title="Remove file">
                            <i class="fa fa-trash"></i>
                          </button>
                          </a>
                        </div>
                      </div>
                      <div class="clearfix"></div>
                    </div>
                  </div>
                  @endforeach
                </div>
              </div>
            @endif
        </div>
    </div>
  </form>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/js/fileinput.js" type="text/javascript"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-fileinput/4.4.7/themes/fa/theme.js" type="text/javascript"></script>

    <script type="text/javascript">
        // $("#file-1").fileinput();
        $("#file-1").fileinput({
            theme: 'fa',
            uploadUrl: "{{route('gallery.featuredImage')}}",
            allowedFileExtensions: ['jpg', 'png', 'gif'],
            overwriteInitial: false,
            maxFileSize:2000,
            maxFilesNum: 10,
            slugCallback: function (filename) {
              // console.log(filename);
              $('.kv-file-upload').attr('title','Set as Featured Image')
                $('.kv-file-upload').html('<i class="fa fa-star text-warning"></i>');
                $(this).val(filename);
                return filename.replace('(', '_').replace(']', '_');
            }

        });

    </script>
    @endsection