@extends('Backend.layouts.app')
@section('content')
<?php

use Carbon\Carbon; ?>
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Event Section </h3>
    <a href="{{route('events.create')}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Event</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
       <div class="table-responsive p-1">
          <table id="event-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr>
                <th>Date</th>
                <th>Title</th>
                <th>Event Date</th>
                <th>Event Time</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td class="">
                  <div>{{ date('Y', strtotime($l->created_at)) }}</div>
                  <div>{{ date('m-d', strtotime($l->created_at)) }}</div>
                </td>
                <td>{{$l->title}}</td>
                <td>
                  {{Carbon::parse($l->start_date)->format('d M Y')}} <div>to</div>
                  {{Carbon::parse($l->end_date)->format('d M Y')}}
                </td>
                <td>
                  {{Carbon::parse($l->start_time)->format('g:i A')}} <div>to</div>
                  {{Carbon::parse($l->end_time)->format('g:i A')}}
                </td>
                <td>
                  <span class="badge {{$l->status=='Saved'?'badge-success':'badge-danger'}}">{{$l->status}}</span></td>
                <td class="col-md-3 col-sm-4">
                  @if($l->status=='Saved')
                  <a class="btn btn-sm btn-primary" target="_blank" href="{{url('/').'/'.$l->slug.'/'.$l->url}}">
                    <i class="fa fa-eye"></i> Preview</a>
                  @endif
                  <a class="btn btn-sm btn-info" href="{{route('events.edit',$l->id)}}">{{ $l->status=='Saved'?'Edit':'Edit & Save'}}</a>
                  <a class="btn btn-sm btn-danger" href="{{route('events.delete',$l->id)}}" ><i class="fa fa-trash"></i> </a></td>
              </tr>
              @endforeach
            </tbody>
          </table>
       </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#event-table').DataTable({
      "columnDefs": [{
          "width": "40px",
          "targets": 0
        },
        {
          "width": "auto",
          "targets": 1
        },
        {
          "width": "80px",
          "targets": 2
        },
        {
          "width": "70px",
          "targets": 3
        },
        {
          "width": "50px",
          "targets": 4
        },
        {
          "width": "100px",
          "targets": 5
        }
      ],
    });
  });
</script>
@endsection