@extends('Backend.layouts.app')
@section('content')
<!-- Page Header -->
<div class="page-header row no-gutters py-4">
	<div class="col-12 col-sm-4 text-center text-sm-left mb-0">
		<span class="text-uppercase page-subtitle">Information Pages</span>
		<h3 class="page-title">Add New Page</h3>
	</div>
</div>
<!-- End Page Header -->
<form class="add-new-post" action="{{isset($edit)?route('events.update', $edit->id):route('events.store')}}" method="post">
<div class="row">
	<div class="col-lg-9 col-md-12">
		<!-- Add New Post Form -->
		<div class="card card-small mb-3">
			<div class="card-body">
					@csrf
					@if(isset($edit))
					<input type="hidden" name="id" value="{{$edit->id}}" />
					@endif
					<input type="hidden" name="status" id="status" />
					<div class="row col-md-12 col-sm-12 p-0 pl-3">
						<label>Event Title <span class="required">*</span> </label>
						<input class="form-control form-control-lg mb-3" id="title" type="text" name="title" value="{{old('title')?old('title'):(isset($edit)?$edit->title:'')}}" placeholder="Your Page Title">
						@if($errors->first('title'))
							<div class="alert alert-danger">
								{{$errors->first('title')}}
							</div>
						@endif
					</div>
					<div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label class="">Start Date <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-3" id="start_date" type="date" name="start_date" value="{{old('start_date')?old('start_date'):(isset($edit)?$edit->start_date:'')}}" placeholder="Your Page Title">
							@if($errors->first('start_date'))
								<div class="alert alert-danger">
									{{$errors->first('start_date')}}
								</div>
							@endif
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label>End Date <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-3" id="end_date" type="date" name="end_date" value="{{old('end_date')?old('end_date'):(isset($edit)?$edit->end_date:'')}}" placeholder="Your Page Title">
							@if($errors->first('end_date'))
								<div class="alert alert-danger">
									{{$errors->first('end_date')}}
								</div>
							@endif
						</div>
					</div>
					<div class="row pr-3">
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label>Time <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-3" id="start_time" type="time" name="start_time" value="{{old('start_time')?old('start_time'):(isset($edit)?$edit->start_time:'')}}" placeholder="Your Page Title">
							@if($errors->first('start_time'))
								<div class="alert alert-danger">
									{{$errors->first('start_time')}}
								</div>
							@endif
						</div>
						<div class="col-md-6 col-sm-6 p-0 pl-3">
							<label>Time <span class="required">*</span> </label>
							<input class="form-control form-control-lg mb-3" id="end_time" type="time" name="end_time" value="{{old('end_time')?old('end_time'):(isset($edit)?$edit->end_time:'')}}" placeholder="Your Page Title">
							@if($errors->first('end_time'))
								<div class="alert alert-danger">
									{{$errors->first('end_time')}}
								</div>
							@endif
						</div>
					</div>
					<div class="row col-md-12 col-sm-12 p-0 pl-3">
						<label>Venue <span class="required">*</span> </label>
						<input class="form-control form-control-lg mb-3" id="venue" type="text" name="venue" value="{{old('venue')?old('venue'):(isset($edit)?$edit->venue:'')}}" placeholder="Event Venue">
						@if($errors->first('venue'))
							<div class="alert alert-danger">
								{{$errors->first('venue')}}
							</div>
						@endif
					</div>
					<div class="col-md-12 col-sm-12 p-0 pl-3">
						<label>Description<span class="required">*</span> </label>  
						<textarea id="mytextarea" name="description">{!! isset($edit)?$edit->description:(old('description')?old('description'):'') !!}</textarea>
						@if($errors->first('description'))
							<div class="alert alert-danger">
								{{$errors->first('description')}}
							</div>
						@endif
					</div>
			</div>
		</div>
		<!-- / Add New Post Form -->
	</div>
	<div class="col-lg-3 col-md-12">
		<!-- Post Overview -->
		<div class='card card-small mb-3'>
			<div class="card-header border-bottom">
				<h6 class="m-0">Actions</h6>
			</div>
			<div class='card-body p-0'>
				<ul class="list-group list-group-flush">
					<li class="list-group-item p-3">
						@if(isset($edit))
						<span class="d-flex mb-2">
							<i class="material-icons mr-1">flag</i>
							<strong class="mr-1">Status:</strong> {{$edit->status}}
							<!-- <a class="ml-auto" href="#">Edit</a> -->
						</span>
						@endif
						<!-- <span class="d-flex mb-2">
	              <i class="material-icons mr-1">visibility</i>
	              <strong class="mr-1">Visibility:</strong>
	              <strong class="text-success">Public</strong>
	              <a class="ml-auto" href="#">Edit</a>
	            </span>
	            <span class="d-flex mb-2">
	              <i class="material-icons mr-1">calendar_today</i>
	              <strong class="mr-1">Schedule:</strong> Now
	              <a class="ml-auto" href="#">Edit</a>
	            </span> -->
						<span class="d-flex">
							<i class="material-icons mr-1">score</i>
							<strong class="mr-1">Preview:</strong>
							<strong class="text-warning">@if(isset($edit) && $edit->status=='Saved')<a target='_blank' href="{{url('/').'/'.$edit->slug.'/'.$edit->url}}"><i class='fa fa-eye'></i> Click</a>@else No @endif</strong>
						</span>
					</li>
					<li class="list-group-item d-flex px-3">
						@if(isset($edit))
                        <button type="submit" id="update" class="btn btn-sm btn-accent ml-auto" name="status" value="save">
                            <i class="material-icons">file_copy</i> {{$edit->status=='Saved'?'Update':'Save'}}
                        </button>
                        @else
                        <button type="submit" id="draft" class="btn btn-sm btn-outline-accent" name="status" value="draft">
                            <i class="material-icons">save</i> Save Draft
                        </button>
                        <button type="submit" id="save" class="btn btn-sm btn-accent ml-auto"  name="status" value="save">
                            <i class="material-icons">file_copy</i> Publish
                        </button>
                        @endif
					</li>
				</ul>
			</div>
		</div>
		<!-- / Post Overview -->
	</div>
</div>
</form>

@endsection