@extends('Backend.layouts.app')
@section('content')
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Downloads Page</h3>
    <a href="{{route('downloads.create')}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Downloads</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
        <div class="table-responsive p-1">
          <table id="download-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr>
                <th>Date</th>
                <th>Title</th>
                <th>File Path</th>
                <th>Type</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td class="">
                  <div>{{ date('Y', strtotime($l->created_at)) }}</div>
                  <div>{{ date('m-d', strtotime($l->created_at)) }}</div>
                </td>
                <td class="wordwrap">{{$l->title}}</td>
                <td class="wordwrap">{{$l->file_path}}</td>
                <td><img class="img-thumbnail" src="{{asset('images/'.$l->file_type.'.png')}}" width="50" height="50" /></td>
                <td><span class="badge {{$l->status=='Saved'?'badge-success':'badge-danger'}}">{{$l->status}}</span></td>
                <td class="col-md-3 col-sm-4">
                  @if($l->status=='Saved')
                  <a target="_blank" href="{{url('/').'/'.$l->slug.'/'.$l->file_path}}" class="text-primary" title="Preview"><i class="fa fa-eye"></i></a>
                  @else
                  <a class="btn btn-primary" onclick="$('form#update').submit();">Save</a> &nbsp; &nbsp;
                  @endif
                  <a class="ml-3" href="{{route('downloads.delete',$l->id)}}"><i class="fa fa-trash text-danger" title="Delete"></i> </a></td>
                <form id="update" action="{{route('downloads.update', $l->id)}}" method="post">
                  @csrf
                </form>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table --> 
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#download-table').DataTable({
      "columnDefs": [{
          "width": "40px",
          "targets": 0
        },
        {
          "width": "auto",
          "targets": 1
        },
        {
          "width": "auto",
          "targets": 2
        },
        {
          "width": "50px",
          "targets": 3
        },
        {
          "width": "50px",
          "targets": 4
        },
        {
          "width": "100px",
          "targets": 5
        }
      ],
    });
  });
</script>
@endsection