@extends('Backend.layouts.app')
@section('content')
<style type="text/css">
	label{
		font-weight: bold !important;
	}
	span.required{
		color:red;
	}

	.btn-file{
		border: 1px solid #000;
		height: 50px;
		font-size: 20px;
	}
	.btn-file input[type=file] {
	  position: absolute;
	  top: 0;
	  right: 0;
	  min-width: 100%;
	  min-height: 100%;
	  font-size: 100px;
	  text-align: right;
	  filter: alpha(opacity=0);
	  opacity: 0;
	  outline: none;
	  background: white;
	  cursor: inherit;
	  display: block;
	}
	span.file{
		font-size: 15px;
		font-weight: 400;
		padding: 5px;
		color:#4D525B;
	}
	.uploadfrm{
		border:1px dotted #BEC0C2;
		padding: 10px;
		margin:10px;
	}
</style>
	<!-- Page Header -->
	<div class="page-header row no-gutters py-4">
	  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
	    <span class="text-uppercase page-subtitle">Downloads Page</span>
	    <h3 class="page-title">Add New Download File</h3>
	  </div>
	</div>
	<!-- End Page Header -->
	<form class="add-new-post" action="{{route('downloads.store')}}" method="post" enctype="multipart/form-data">
	<div class="row">
	  <div class="col-lg-9 col-md-12">
	    <!-- Add New Post Form -->
	    <div class="card card-small mb-3">
	      <div class="card-body">
	        	@csrf
	          <input type="hidden" name="status" id="status" />
	          <label>Title <span class="required">*</span> </label>
	          <input class="form-control form-control-lg mb-3" id="title" type="text" name="title" value="{{old('title')??''}}" placeholder="File Title">
	          @if($errors->first('title'))
	          <div class="text-danger mb-2">* 
	          	{{$errors->first('title')}}
	          </div>
	          @endif
	          <label>Upload file <span class="required">*</span></label>
	          <div class="col-md-12 uploadfrm">
			    <p><span class="col-md-3 col-sm-4 pull-left btn btn-file">
	            <i class="fa fa-plus"></i> Browse file <input  type="file" id="file" name="file" class="btn btn-md" accept=".doc, .docx, .xls, .xlsx, .ppt, .pptx, .txt, .pdf">
	            </span>
	            <span class="file col-md-8 col-md-offset-1">Upload your document here. <span class="required">Supported format: .docx, .xlsx,.pptx, .pdf </span></span></p>
			  </div>			  
	          @if($errors->first('file'))
	          <div class="text-danger mb-2">*
	          	{{$errors->first('file')}}
	          </div>
	          @endif
	      </div>
	    </div>
	    <!-- / Add New Post Form -->
	  </div>
	  <div class="col-lg-3 col-md-12">
	    <!-- Post Overview -->
	    <div class='card card-small mb-3'>
	      <div class="card-header border-bottom">
	        <h6 class="m-0">Actions</h6>
	      </div>
	      <div class='card-body p-0'>
	        <ul class="list-group list-group-flush">
	          <li class="list-group-item p-3">
	            <span class="d-flex mb-2">
	              <i class="material-icons mr-1">flag</i>
	              <strong class="mr-1">Status:</strong>
	            </span>
	            <span class="d-flex">
	              <i class="material-icons mr-1">score</i>
	              <strong class="mr-1">Preview:</strong>
	              <strong class="text-warning"> No</strong>
	            </span>
	          </li>
	          <li class="list-group-item d-flex px-3">
				@if(isset($edit))
				<button type="submit" id="update" class="btn btn-sm btn-accent ml-auto" name="status" value="save">
					<i class="material-icons">file_copy</i> {{$edit->status=='Saved'?'Update':'Save'}}
				</button>
				@else
				<button type="submit" id="draft" class="btn btn-sm btn-outline-accent" name="status" value="draft">
					<i class="material-icons">save</i> Save Draft
				</button>
				<button type="submit" id="save" class="btn btn-sm btn-accent ml-auto"  name="status" value="save">
					<i class="material-icons">file_copy</i> Publish
				</button>
				@endif
	          </li>
	        </ul>
	      </div>
	    </div>
	    <!-- / Post Overview -->
	  </div>
	</div>
</form>

	<script type="text/javascript">
		$('#file').on('change', function(e){
			$('span.file').html(this.files[0].name+" <span class='border rounded border-green ml-2 p-1'><i class='fa fa-check text-success'></i></span>");
		})

	</script>

@endsection
