@extends('Backend.layouts.app')
@section('content')
<?php

use Carbon\Carbon; ?>

<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<br>
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Contact Us Request</h3>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
        <div class="table-responsive p-1">
          <table id="contact-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr>
                <th>Full Name</th>
                <th>Email</th>
                <th>Subject</th>
                <th>Status</th>
                <th>Action</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td>{{$l->fullname}}</td>
                <td>{{$l->email}}</td>
                <td>{{$l->subject}}</td>
                <td><span class="badge {{$l->status=="Pending"?'badge-danger':'badge-success'}}"> {{$l->status}}</span></td>
                <td class="col-md-3 col-sm-4">
                  @if($l->status=='Pending')
                  <a class="btn btn-success btn-sm" href="{{route('contactus.complete', $l->id)}}">Complete</a>
                  @endif
                  <a class="btn btn-danger btn-sm" href="{{route('contactus.delete', $l->id)}}">
                    <i class="fa fa-trash"></i>
                  </a></td>
              </tr>
              @endforeach
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#contact-table').DataTable({
      "columnDefs": [{
          "width": "200px",
          "targets": 0
        },
        {
          "width": "200px",
          "targets": 1
        },
        {
          "width": "auto",
          "targets": 2
        },
        {
          "width": "50px",
          "targets": 3
        },
        {
          "width": "150px",
          "targets": 4
        },

      ],
    });
  });
</script>
@endsection