@extends('Backend.layouts.app')
@section('content')
<?php

use Carbon\Carbon; 
use App\Http\Helpers\AppHelper;
?>
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Blog List </h3>
    <a href="{{route('blog.create',['list'=>$list])}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Blog</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
       <div class="table-responsive p-1">
          <table id="event-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr>
                <th>Date</th>
                <th>Category Name</th>
                <th>Title</th>
                <th>Author</th>
                <th>Gender</th>
                <th>Event name</th>
                <th>Status</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td class="font-weight-bold">
                  {{ Carbon::parse($l->created_at)->format('Y M d H:i A')}}
                </td>
                <td>
                  {{$l->category->name}}
                </td>
                <td>{{$l->title}}</td>
                <td>{{$l->author}}</td>
              <td>{{AppHelper::gender[$l->gender]}}</td>
                <td>{{$l->eventName}}</td>
                <td>
                    @if ($l->status==0)
                <a class="btn btn-md btn-danger" href="{{ route('blog.statusChange',$l->id)}}">Approve</a>
                    @else
                    <span class="badge badge-success">Approved</span>
                    @endif
                </td>
                <td class="col-md-3 col-sm-4">                
                  <a target="_blank" class="btn btn-sm btn-success" href="{{ route('blogfront.show',$l->id)}}">
                    <i class="fa fa-eye"></i>
                  </a>
                  <form class="d-inline" action="{{ route('blog.edit',$l->id)}}" method="GET">
                      <button type="submit" class="btn btn-sm btn-primary">Edit</button>
                  </form>
                  {!! Form::open(['route' => ['blog.destroy',$l->id],'method'=>'DELETE','class'=>'d-inline']) !!}
                  {!! Form::submit('Delete', array('class' => 'btn btn-sm btn-danger' )) !!}
                      {!! Form::close() !!}
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
       </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#event-table').DataTable({
      "columnDefs": [
        {
          "width": "10%",
          "targets": 0
        },
        {
          "width": "10%",
          "targets": 1
        },
        {
          "width": "150px",
          "targets": 2
        },
        {
          "width": "70px",
          "targets": 3
        },
        {
          "width": "100px",
          "targets": 0
        },
        {
          "width": "150px",
          "targets": 1
        },
        {
          "width": "150px",
          "targets": 2
        },
        {
          "width": "70px",
          "targets": 3
        },
        {
          "width": "70px",
          "targets": 3
        },

      ],
    });
  });
</script>
@endsection
