@extends('Backend.layouts.app')
@section('content')
<?php
	use App\Http\Helpers\AppHelper;
?>
{{-- @dd($errors) --}}
<style type="text/css">
	label {
		font-weight: bold !important;
	}

	span.required {
		color: red;
	}
</style>
<!-- Page Header -->
<div class="page-header row no-gutters py-4">
	<div class="col-12 col-sm-4 text-center text-sm-left mb-0">
		<span class="text-uppercase page-subtitle">Blog Pages</span>
		<h3 class="page-title">{{isset($edit)?'Edit Blog' : 'Add New Blog'}}</h3>
		
	</div>
</div>
<!-- End Page Header -->
@if(isset($edit))
{!! Form::open(['route' => ['blog.update',$edit->id],'method'=>'PUT','data-parsley-validation'=> '','files' => true]) !!}
@else
{!! Form::open(['route' => ['blog.store'],'method'=>'POST','data-parsley-validation'=> '','files' => true]) !!}
@endif
<div class="row">
	<div class="col-lg-9 col-md-12">
		<!-- Add New Post Form -->
		<div class="card card-small mb-3">
			<div class="card-body">
                @if(isset($edit))
                    {!! Form::label('title','Title:') !!}
                    {!! Form::text('title',$edit->title,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
                    {!! Form::label('content','Content:') !!}
                    {!! Form::textarea('content',$edit->content,array('class' =>'form-control','required'=>'')) !!}
                    {!! Form::label('category_id','Category Name:') !!}
					{!! Form::select('category_id', $category,$edit->category_id,array('class' =>'form-control','required'=>'')); !!}
                    {!! Form::label('eventName','Event Name:') !!}
                    {!! Form::text('eventName',$edit->eventName,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
                    {!! Form::label('author','Author:') !!}
                    {!! Form::text('author',$edit->author,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
                    {!! Form::label('featuredImage','Upload Featured Image:') !!}
                    {!! Form::file('featuredImage',array('class'=>'form-control')) !!}
                    {!! Form::label('gender','Gender:') !!}
                    {!! Form::select('gender',AppHelper::gender,$edit->gender,array('class' =>'form-control','required'=>'')); !!}
                @else
					{!! Form::label('title','Title:') !!}
					{!! Form::text('title', null,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
					{!! Form::label('content','Content:') !!}
					{!! Form::textarea('content',null,array('class' =>'form-control','required'=>'')) !!}
					{!! Form::label('category_id','Category Name:') !!}
					{!! Form::select('category_id', $category , '1',array('class' =>'form-control','required'=>'')); !!}
					{!! Form::label('eventName','Event Name:') !!}
					{!! Form::text('eventName', null,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
					{!! Form::label('featuredImage','Upload Featured Image:') !!}
					{!! Form::file('featuredImage',array('class'=>'form-control'))!!}
					{!! Form::label('author','Author:') !!}
					{!! Form::text('author', null,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
					{!! Form::label('gender','Gender:') !!}
					{!! Form::select('gender',AppHelper::gender, '1',array('class' =>'form-control','required'=>'')); !!}
                @endif
			</div>
		</div>
		<!-- / Add New Post Form -->
	</div>
	<div class="col-lg-3 col-md-12">
		<!-- Post Overview -->
		<div class='card card-small mb-3'>
			<div class="card-header border-bottom">
				<h6 class="m-0">Actions</h6>
			</div>
			<div class='card-body p-0'>
				<ul class="list-group list-group-flush">
					<li class="list-group-item d-flex px-3">
                        @if(isset($edit))
                        <button type="submit" id="update" class="btn btn-sm btn-accent ml-auto" name="status" value="save">
                            <i class="material-icons">file_copy</i> {{$edit->status=='Saved'?'Update':'Save'}}
                        </button>
                        @else
                        <button type="submit" id="draft" class="btn btn-sm btn-outline-accent" name="status" value="draft">
                            <i class="material-icons">save</i> Save Draft
                        </button>
                        <button type="submit" id="save" class="btn btn-sm btn-accent ml-auto"  name="status" value="save">
                            <i class="material-icons">file_copy</i> Publish
                        </button>
                        @endif
					</li>
				</ul>
			</div>
		</div>
		<!-- / Post Overview -->
	</div>
</div>
{!! Form::close() !!}
<script type="text/javascript">
	
</script>

@endsection
