@extends('Backend.layouts.app')
@section('content')
<?php

use Carbon\Carbon; ?>
<!-- Page Header -->
@if(Session::has('msg'))
<div class="col-md-4 col-sm-5 float-right alert alert-success alert-dismissible m-2 mt-4 fade show" role="alert">
  {{Session::get('msg')}}.
  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
    <span aria-hidden="true">&times;</span>
  </button>
</div>
@endif
<div class="page-header row no-gutters py-4">
  <div class="col-12 col-sm-4 text-center text-sm-left mb-0">
    <!-- <span class="text-uppercase page-subtitle">Overview</span> -->
    <h3 class="page-title">Blog Category</h3>
    <a href="{{route('blogcategory.create',['list'=>$list])}}" class="btn btn-primary mt-4 ml-2"><i class="fa fa-plus"></i> Add New Category</a>
  </div>
</div>
<!-- End Page Header -->
<!-- Default Light Table -->
<div class="row">
  <div class="col">
    <div class="card card-small mb-4">
      <div class="card-body p-3 text-center">
       <div class="table-responsive p-1">
          <table id="event-table" class="table table-striped table-bordered" style="width:100%">
            <thead>
              <tr>
                <th>Date</th>
                <th>Name</th>
                <th>Description</th>
                <th>Actions</th>
              </tr>
            </thead>
            <tbody>
              @foreach($list as $l)
              <tr>
                <td class="font-weight-bold">{{ Carbon::parse($l->created_at)->format('Y M d H:i A')}}
                </td>
                <td>{{$l->name}}</td>
                <td>{{$l->description}}</td>
                <td class="col-md-3 col-sm-4">
                <a class="btn btn-sm btn-success" href="{{ route('blogcategory.show',$l->id)}}"><i class="fa fa-eye"></i>
                </a>
                <form class="d-inline" action="{{ route('blogcategory.edit',$l->id)}}" method="GET">
                    <button type="submit" class="btn btn-sm btn-primary">Edit</button>
                </form>
              
                {!! Form::open(['route' => ['blogcategory.destroy',$l->id],'method'=>'DELETE','class'=>'d-inline']) !!}
                {!! Form::submit('Delete', array('class' => 'btn btn-sm btn-danger' )) !!}
                    {!! Form::close() !!}
                </td>
              </tr>
              @endforeach
            </tbody>
          </table>
       </div>
      </div>
    </div>
  </div>
</div>
<!-- End Default Light Table -->
<script type="text/javascript">
  $(document).ready(function() {
    setTimeout(function() {
      $('.alert .close').click()
    }, 3000);
    $('#event-table').DataTable({
      "columnDefs": [{
          "width": "100px",
          "targets": 0
        },
        {
          "width": "150px",
          "targets": 1
        },
        {
          "width": "150px",
          "targets": 2
        },
        {
          "width": "70px",
          "targets": 3
        },
      ],
    });
  });
</script>
@endsection
