@extends('Backend.layouts.app')
@section('content')
{{-- @dd($errors) --}}
<style type="text/css">
	label {
		font-weight: bold !important;
	}

	span.required {
		color: red;
	}
</style>
<!-- Page Header -->
<div class="page-header row no-gutters py-4">
	<div class="col-12 col-sm-4 text-center text-sm-left mb-0">
		<span class="text-uppercase page-subtitle">Blog Pages</span>
		<h3 class="page-title">Add New Category</h3>
	</div>
</div>
<!-- End Page Header -->
@if(isset($edit))
{!! Form::open(['route' => ['blogcategory.update',$edit->id],'method'=>'PUT','data-parsley-validation'=> '']) !!}
@else
{!! Form::open(['route' => ['blogcategory.store'],'method'=>'POST','data-parsley-validation'=> '']) !!}
@endif
<div class="row">
	<div class="col-lg-9 col-md-12">
		<!-- Add New Post Form -->
		<div class="card card-small mb-3">
			<div class="card-body">
                @if(isset($edit))                    
					{!! Form::label('name','Name:') !!}
					{!! Form::text('name', $edit->name,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
					{!! Form::label('description','Description:') !!}
					{!! Form::textarea('description',$edit->description,array('class' =>'form-control','required'=>'')) !!}
				@else
					{!! Form::label('name','Name:') !!}
					{!! Form::text('name', null,array('class' => 'form-control','required'=>'','maxlength'=>'20')) !!}
					{!! Form::label('description','Description:') !!}
					{!! Form::textarea('description',null,array('class' =>'form-control','required'=>'')) !!}
				@endif
			</div>
		</div>
		<!-- / Add New Post Form -->
	</div>
	<div class="col-lg-3 col-md-12">
		<!-- Post Overview -->
		<div class='card card-small mb-3'>
			<div class="card-header border-bottom">
				<h6 class="m-0">Actions</h6>
			</div>
			<div class='card-body p-0'>
				<ul class="list-group list-group-flush">
					<li class="list-group-item d-flex px-3">
                        @if (isset($edit))
						<button type="submit" id="update" class="btn btn-sm btn-accent ml-auto">
							<i class="material-icons">file_copy</i> Update
						</button>
                        @else
						<button id="save" class="btn btn-sm btn-accent ml-auto">
							<i class="material-icons">file_copy</i> Publish
						</button>
						@endif
					</li>
				</ul>
			</div>
		</div>
		<!-- / Post Overview -->
	</div>
</div>
{!! Form::close() !!}

@endsection
